#include <iostream>
#include <vector>
#include <queue>

class Graf{
private:
    int brojElem;
    std::vector<int>* liste;
public:
    Graf() : brojElem(0), liste(nullptr) {}
    Graf(int& br) : brojElem(br), liste(new std::vector<int>[br]) {}
    void dodajGranu(int& u, int& v){
        liste[u-1].emplace_back(v-1);
        liste[v-1].emplace_back(u-1);
    }
    
    int duzinaNajkracegPuta(int& u, int& v){
        bool* poseceno = new bool[brojElem];
        int* rastojanje = new int[brojElem];
        for(int i = 0; i < brojElem; i++){
            poseceno[i] = false;
            rastojanje[i] = brojElem; // moglo bi i INT32_MAX, ne bih zbog kompajlera :)
        }

        std::queue<int> q;

        q.push(u-1);
        poseceno[u-1] = true;
        rastojanje[u-1] = 0;

        while(!q.empty()){
            int trenutno = q.front();
            q.pop();
            for(int naselje : liste[trenutno]){
                if(!poseceno[naselje]){
                    q.push(naselje);
                    poseceno[naselje] = true;
                    rastojanje[naselje] = rastojanje[trenutno] + 1;

                    if(naselje == v-1){
                        break;
                    }
                }
            }
        }

        int najkraciPut = rastojanje[v-1];
        delete[] rastojanje;
        delete[] poseceno;
        return najkraciPut;
    }
};

int main(){
    int n, temp, u, v, q, a, b, x;
    short int dogadjaj;

    std::cin >> n;

    Graf naselja(n);
    std::vector<int> rasporedNaselja;
    rasporedNaselja.reserve(n);

    for(int i = 0; i < n; i++){
        std::cin >> temp;
        rasporedNaselja.emplace_back(temp);
    }

    for(int i = 0; i < n - 1; i++){
        std::cin >> u >> v;
        naselja.dodajGranu(u, v);
    }

    std::cin >> q;

    for(int i = 0; i < q; i++){
        std::cin >> dogadjaj;
        if(dogadjaj == 1){
            std::cin >> a >> b;
            temp = rasporedNaselja[a-1];
            rasporedNaselja[a-1] = rasporedNaselja[b-1];
            rasporedNaselja[b-1] = temp; 
        }
        else if(dogadjaj == 2){
            std::cin >> a >> b >> x;


            int najdaljiPut = -1; 
            for(int j = a - 1; j <= b - 1; j++){
                int tempPut = naselja.duzinaNajkracegPuta(x, rasporedNaselja[j]);
                if(tempPut > najdaljiPut)
                    najdaljiPut = tempPut;
            }
            std::cout << najdaljiPut << std::endl;
        }
    }
}